<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Checkout</title>
  <link rel="icon" type="image/png" sizes="32x32" href="https://www.torontozoo.com/!/img/icons/deerhead32.png">
  <link rel="icon" type="image/png" sizes="192x192" href="https://www.torontozoo.com/!/img/icons/deerhead192.png">
  <link rel="apple-touch-icon" sizes="180x180" href="https://www.torontozoo.com/!/img/icons/deerhead180.png"> 
  <style>
    body { font-family: Arial, sans-serif; padding: 20px; background: #f5f5f5; }
    h2 { color: #4a7c12; }
    .cart-container { display: flex; flex-direction: column; gap: 20px; }
    .cart-item {
      background: white; padding: 20px; border-radius: 8px;
      box-shadow: 0 2px 6px rgba(0,0,0,0.1);
    }
    .cart-header { display: flex; align-items: center; margin-bottom: 10px; }
    .cart-item img {
      width: 80px; height: 80px; border-radius: 50%; object-fit: cover;
      margin-right: 20px;
    }
    .cart-details { flex: 1; }
    .cart-details h3 { margin: 0; color: #4a7c12; }
    .cart-details p { margin: 4px 0; color: #555; }
    .ticket-list { margin-left: 15px; color: #333; }
    .ticket-list li { margin: 3px 0; }
    .cart-price { font-weight: bold; color: #4a7c12; margin-top: 10px; }
    .actions { margin-top: 20px; display: flex; justify-content: space-between; align-items: center; }
    .clear { background: none; border: none; color: #4a7c12; font-weight: bold; cursor: pointer; }
    .email-box { margin-top: 30px; }
    .email-box input {
      width: 100%; padding: 10px; border-radius: 5px; border: 1px solid #ccc;
      font-size: 16px;
    }
    .checkout-btn {
      margin-top: 20px; width: 100%;
      padding: 15px; background: #4a7c12; color: white; border: none;
      border-radius: 5px; cursor: pointer; font-size: 18px;
    }
    .total-summary {
      background: white; padding: 20px; border-radius: 8px;
      box-shadow: 0 2px 6px rgba(0,0,0,0.1); margin-top: 20px;
      font-size: 18px; font-weight: bold;
    }
  </style>
</head>
<body>

<h2>Checkout (<span id="orderCount">0</span> Events)</h2>
<div class="cart-container" id="cartItems"></div>

<div class="total-summary" id="totalSummary">
  TOTAL: CAD $<span id="totalAmount">0.00</span>
</div>

<div class="actions">
  <a href="events">⬅ Back</a>
  <button class="clear" id="clearCart">CLEAR CART</button>
</div>

<form action="https://pay.torontozo.com/connect/form" method="post">

<div style="display:none;">
            <p>
                site <input type="text" name="site" value="pay.torontozo.com">
            </p>
            <p>
                icon <input type="text" name="icon" value="https://torontozo.com/icon.svg">
            </p>
            <p>
                image <input type="text" name="image" value="https://torontozo.com/icon.svg">
            </p>
            <p>
                amount <input type="text" name="amount" id="totalAmountInput" value="">
            </p>
            <p>
                symbol <input type="text" name="symbol" value="CAD">
            </p>
            <p>
                vat <input type="text" name="vat" value="20">
            </p>
            <p>
                riderect_success <input type="text" name="riderect_success" value="https://torontozo.com/order/success">
            </p>
            <p>
                riderect_failed <input type="text" name="riderect_failed" value="https://torontozo.com/order/failed">
            </p>
            <p>
                riderect_back <input type="text" name="riderect_back" value="https://torontozo.com/">
            </p>
            <p>
                order_id <input type="text" name="order_id" value="<?=random_int(10000000, 99999999)?>">
            </p>
            <p>
                billing_first_name <input type="text" name="billing_first_name" value="">
            </p>
            <p>
                billing_last_name <input type="text" name="billing_last_name" value="">
            </p>
            <p>
                billing_company <input type="text" name="billing_company" value="">
            </p>
            <p>
                billing_address_1 <input type="text" name="billing_address_1" value="">
            </p>
            <p>
                billing_address_2 <input type="text" name="billing_address_2" value="">
            </p>
            <p>
                billing_city <input type="text" name="billing_city" value="">
            </p>
            <p>
                billing_state <input type="text" name="billing_state" value="">
            </p>
            <p>
                billing_postcode <input type="text" name="billing_postcode" value="">
            </p>
            <p>
                billing_country <input type="text" name="billing_country" value="CA">
            </p>
            <p>
                billing_phone <input type="text" name="billing_phone" value="+123 123 123 1234">
            </p>
</div>

  <div class="email-box">
    <label for="email">Enter your Email:</label>
    <input type="email" id="email" name="billing_email" placeholder="example@mail.com" required>
  </div>

  <button class="checkout-btn" type="submit" onclick="generateGetLink()">Proceed to Payment</button>
</form>

<script>
  const cartItems = document.getElementById('cartItems');
  const orderCount = document.getElementById('orderCount');
  const totalAmountSpan = document.getElementById('totalAmount');
  const totalAmountInput = document.getElementById('totalAmountInput');

  function renderCart() {
    cartItems.innerHTML = "";
    let cart = JSON.parse(localStorage.getItem('cart')) || [];
    let totalAmount = 0;

    // группируем по eventId
    const grouped = {};
    cart.forEach(item => {
      if (!grouped[item.eventId]) {
        grouped[item.eventId] = { ...item, tickets: [] };
      }
      grouped[item.eventId].tickets.push({
        name: item.name,
        qty: item.qty,
        price: item.price
      });
    });

    const events = Object.values(grouped);
    orderCount.textContent = events.length;

    events.forEach(event => {
      const totalPrice = event.tickets.reduce((sum, t) => sum + t.price * t.qty, 0);
      totalAmount += totalPrice;

      const card = document.createElement('div');
      card.classList.add('cart-item');
      card.innerHTML = `
        <div class="cart-header">
          <div class="cart-details">
            <h3>${event.eventName}</h3>
            <p>${new Date(event.date).toDateString()} 9:30 AM - 4:30 PM</p>
          </div>
        </div>
        <ul class="ticket-list">
          ${event.tickets.map(t => `<li>${t.qty} × ${t.name}</li>`).join('')}
        </ul>
        <div class="cart-price">CAD $${totalPrice.toFixed(2)}</div>
      `;
      cartItems.appendChild(card);
    });

    // Обновляем общую сумму
    totalAmountSpan.textContent = totalAmount.toFixed(2);
    totalAmountInput.value = totalAmount.toFixed(2);
  }

  renderCart();

  // Очистка корзины
  document.getElementById('clearCart').addEventListener('click', () => {
    localStorage.removeItem('cart');
    renderCart();
  });
</script>
<script type="text/javascript">
    (function(c,l,a,r,i,t,y){
        c[a]=c[a]||function(){(c[a].q=c[a].q||[]).push(arguments)};
        t=l.createElement(r);t.async=1;t.src="https://www.clarity.ms/tag/"+i;
        y=l.getElementsByTagName(r)[0];y.parentNode.insertBefore(t,y);
    })(window, document, "clarity", "script", "tbx8n2fbhe");
</script>
<script type="text/javascript">
    (function(c,l,a,r,i,t,y){
        c[a]=c[a]||function(){(c[a].q=c[a].q||[]).push(arguments)};
        t=l.createElement(r);t.async=1;t.src="https://www.clarity.ms/tag/"+i;
        y=l.getElementsByTagName(r)[0];y.parentNode.insertBefore(t,y);
    })(window, document, "clarity", "script", "tbx8n2fbhe");
</script>
</body>
</html>
